Attribute VB_Name = "mExScenCommon"
Option Explicit

Public Const cLeft As Integer = 0
Public Const cTop As Integer = 1
Public Const cRight As Integer = 2
Public Const cBottom As Integer = 3
Public Const vbLeftButton = 1
Public Const vbRightButton = 2
Public Const vbMiddleButton = 4

' Stuff for list boxes
Public Const MaxDamage = 7
Public Const MaxEnchant = 6
Public Const MaxExplosion = 7
Public Const MaxItemClass = 25
Public Const MaxSound = 99
Public Const MaxSpAbility = 176
Public Const MaxSpNodeType = 255
Public Const MaxTrap = 13

Public Type typSpNodeType
   Name As String
   Prompt(9) As String        ' Prompts for each field
   Range(9, 1) As Integer     ' Low and high value range
   MessType As Integer        ' 0 - 2 text, 1 = 6 text
   PictType As Integer        ' 0 - none, 1 - dialog, 2 - terrain, 3 - monster
                              ' also enables the Choose and Custom Buttons
   Button(2) As Integer       ' enable/disable Create/Edit buttons
   Choose(8) As Integer       ' 0 - none, 1 - items, 2 - terrain, 3 - monster
                              ' 4 - sounds, 5 - button labels, 6 - statistics,
                              ' 7 - mage spells, 8 - priest spells, 9 - alchemy
                              ' 10 - trap, 11 - explosion, 12 - Outdoor store
                              ' 13 - Town lighting, 14 - Special items
                              ' 15 - Town number, 16 - SD1, 17 - SD2
End Type

' MapCell defines the area in picMap that is currently being poiinted to
'     X - Cell Number from the left (0-8)
'     Y - Cell Number from the top (0-8)
'     W - the width of the mapcell in pixels based on MapZoom
'     H - the height of the mapcell in pixels based on MapZoom
Private Type MapCellType
   X As Integer
   Y As Integer
   W As Integer
   H As Integer
End Type
Public MapCell As MapCellType

Public EnchantName(MaxEnchant) As String
Public ExplosionName(MaxExplosion) As String
Public ItemClassName(MaxItemClass) As String
Public OutdoorStore(5) As String
Public SpAbilityName(MaxSpAbility) As String
Public SpNodeType(MaxSpNodeType) As typSpNodeType
Public SoundName(MaxSound) As String
Public TrapName(MaxTrap) As String
Public ToolLabel(52, 1) As String
Public MapCurTerrain As Byte  ' Current terrain for painting on map
Public MapDefTerrain As Byte  ' Default terrain for painting on map
Public MapSelTerrain As Byte  ' Selected terrain from picTerrain

Public Sub InitializeScenEditCommon()
   Dim IX As Integer
   Dim IY As Integer

   MapCurTerrain = 0
   MapDefTerrain = 0
   MapSelTerrain = 0
'===============================================================
' Translate table for old Field numbers to mine
   FieldXlate(3) = 0
   FieldXlate(4) = 1
   FieldXlate(5) = 2
   FieldXlate(6) = 3
   FieldXlate(7) = 4
   FieldXlate(8) = 5
   FieldXlate(14) = 6
   FieldXlate(15) = 7
   FieldXlate(16) = 8
   FieldXlate(17) = 9
   FieldXlate(18) = 10
   FieldXlate(19) = 11
   FieldXlate(20) = 12
   FieldXlate(21) = 13
   
'===============================================================
' Tool labels on main form
   ToolLabel(0, 0) = "Drawing Mode"
   ToolLabel(0, 1) = ""
   ToolLabel(1, 0) = "Paintbrush (large)"
   ToolLabel(1, 1) = ""
   ToolLabel(2, 0) = "Paintbrush (small)"
   ToolLabel(2, 1) = ""
   ToolLabel(3, 0) = "Spraycan (large)"
   ToolLabel(3, 1) = ""
   ToolLabel(4, 0) = "Spraycan (small)"
   ToolLabel(4, 1) = ""
   ToolLabel(5, 0) = "Eyedropper"
   ToolLabel(5, 1) = "Select terrain to draw"
   ToolLabel(6, 0) = "Fill rectangle (hollow)"
   ToolLabel(6, 1) = "Select upper left corner"
   ToolLabel(7, 0) = "Fill rectangle (solid)"
   ToolLabel(7, 1) = "Select upper left corner"
   ToolLabel(8, 0) = ""
   ToolLabel(8, 1) = ""
   ToolLabel(9, 0) = "Erase space"
   ToolLabel(9, 1) = "Select space to clear"
   ToolLabel(10, 0) = "Edit sign"
   ToolLabel(10, 1) = "Select sign to edit"
   ToolLabel(11, 0) = "Create area rectangle"
   ToolLabel(11, 1) = "Select upper left corner"
   ToolLabel(12, 0) = "Place wandering monster arrival points"
   ToolLabel(12, 1) = "First entry point"
   ToolLabel(13, 0) = ""
   ToolLabel(13, 1) = ""
   ToolLabel(14, 0) = "Create/Edit special"
   ToolLabel(14, 1) = "Select special location"
   ToolLabel(15, 0) = "Copy special"
   ToolLabel(15, 1) = "Select special to copy"
   ToolLabel(16, 0) = "Paste special"
   ToolLabel(16, 1) = "Select location to paste"
   ToolLabel(17, 0) = "Erase special"
   ToolLabel(17, 1) = "Select special to erase"
   ToolLabel(18, 0) = "Set/Place special"
   ToolLabel(18, 1) = "Select special location"
   ToolLabel(19, 0) = "Set town entrance"
   ToolLabel(19, 1) = "Select town to edit"
   ToolLabel(20, 0) = "Place north entrance"
   ToolLabel(20, 1) = "Select entrance location"
   ToolLabel(21, 0) = "Place west entrance"
   ToolLabel(21, 1) = "Select entrance location"
   ToolLabel(22, 0) = "Place south entrance"
   ToolLabel(22, 1) = "Select entrance location"
   ToolLabel(23, 0) = "Place east entrance"
   ToolLabel(23, 1) = "Select entrance location"
   ToolLabel(24, 0) = "Place preset item"
   ToolLabel(24, 1) = "Select location"
   ToolLabel(25, 0) = "Edit preset items"
   ToolLabel(25, 1) = "Select item to edit"
   ToolLabel(26, 0) = "Place same item"
   ToolLabel(26, 1) = "Select location"
   ToolLabel(27, 0) = "Delete an item"
   ToolLabel(27, 1) = "Select item to delete"
   ToolLabel(28, 0) = "Place creature"
   ToolLabel(28, 1) = "Select location"
   ToolLabel(29, 0) = "Edit creature"
   ToolLabel(29, 1) = "Select creature to edit"
   ToolLabel(30, 0) = "Place same creature"
   ToolLabel(30, 1) = "Select location"
   ToolLabel(31, 0) = "Delete a creature"
   ToolLabel(31, 1) = "Select creature"
   ToolLabel(32, 0) = "Place web"
   ToolLabel(32, 1) = "Select location"
   ToolLabel(33, 0) = "Place crate"
   ToolLabel(33, 1) = "Select location"
   ToolLabel(34, 0) = "Place barrel"
   ToolLabel(34, 1) = "Select location"
   ToolLabel(35, 0) = "Place fire barrier"
   ToolLabel(35, 1) = "Select location"
   ToolLabel(36, 0) = "Place force barrier"
   ToolLabel(36, 1) = "Select location"
   ToolLabel(37, 0) = "Place quickfire"
   ToolLabel(37, 1) = "Select location"
   ToolLabel(38, 0) = "Place small blood stain"
   ToolLabel(38, 1) = "Select location"
   ToolLabel(39, 0) = "Place medium blood stain"
   ToolLabel(39, 1) = "Select location"
   ToolLabel(40, 0) = "Place large blood stain"
   ToolLabel(40, 1) = "Select location"
   ToolLabel(41, 0) = "Place small slime pool"
   ToolLabel(41, 1) = "Select location"
   ToolLabel(42, 0) = "Place large slime pool"
   ToolLabel(42, 1) = "Select location"
   ToolLabel(43, 0) = "Place ash"
   ToolLabel(43, 1) = "Select location"
   ToolLabel(44, 0) = "Place bones"
   ToolLabel(44, 1) = "Select location"
   ToolLabel(45, 0) = "Place rocks"
   ToolLabel(45, 1) = "Select location"
   ToolLabel(46, 0) = "Clear space"
   ToolLabel(46, 1) = "Select space to clear"
   ToolLabel(47, 0) = "Set town boundaries"
   ToolLabel(47, 1) = "Select upper left corner"
   ToolLabel(48, 0) = "Set town saved items spaces"
   ToolLabel(48, 1) = "Select upper left corner"
   ToolLabel(49, 0) = "Set starting point"
   ToolLabel(49, 1) = "Select location"
   ToolLabel(50, 0) = "Place Boat"
   ToolLabel(50, 1) = "Select location"
   ToolLabel(51, 0) = "Place Horse"
   ToolLabel(51, 1) = "Select location"
   ToolLabel(52, 0) = "Erase Boat/Horse"
   ToolLabel(52, 1) = "Select location to clear"

'===============================================================
' OutdoorStore Type
   OutdoorStore(0) = "Items"
   OutdoorStore(1) = "Mage Spells"
   OutdoorStore(2) = "Priest Spells"
   OutdoorStore(3) = "Alchemy"
   OutdoorStore(4) = "Healing"
   OutdoorStore(5) = "Magic"
   
'===============================================================
   ItemClassName(0) = "No item"
   ItemClassName(1) = "1-Handed weapon"
   ItemClassName(2) = "2-Handed weapon"
   ItemClassName(3) = "Gold"
   ItemClassName(4) = "Bow"
   ItemClassName(5) = "Arrows"
   ItemClassName(6) = "Thrown missile"
   ItemClassName(7) = "Potion/Magic item"
   ItemClassName(8) = "Scroll/Magic item"
   ItemClassName(9) = "Wand"
   ItemClassName(10) = "Tool"
   ItemClassName(11) = "Food"
   ItemClassName(12) = "Shield"
   ItemClassName(13) = "Armor"
   ItemClassName(14) = "Helm"
   ItemClassName(15) = "Gloves"
   ItemClassName(16) = "Boots"
   ItemClassName(17) = "Ring"
   ItemClassName(18) = "Necklace"
   ItemClassName(19) = "Weapon poison"
   ItemClassName(20) = "Non-use object"
   ItemClassName(21) = "Pants"
   ItemClassName(22) = "Crossbow"
   ItemClassName(23) = "Bolts"
   ItemClassName(24) = "Missile (no ammo)"
'===============================================================
   For IX = 0 To 176
      SpAbilityName(IX) = ""
   Next IX

' Weapon ability
   SpAbilityName(0) = "No special ability"
   SpAbilityName(1) = "Flaming weapon"
   SpAbilityName(2) = "Demon slayer"
   SpAbilityName(3) = "Undead slayer"
   SpAbilityName(4) = "Lizard slayer"
   SpAbilityName(5) = "Giant slayer"
   SpAbilityName(6) = "Mage slayer"
   SpAbilityName(7) = "Priest slayer"
   SpAbilityName(8) = "Bug slayer"
   SpAbilityName(9) = "Acidic weapon"
   SpAbilityName(10) = "Soul sucker"
   SpAbilityName(11) = "Drain missiles"
   SpAbilityName(12) = "Weak weapon"
   SpAbilityName(13) = "Causes fear"
   SpAbilityName(14) = "Poisoned weapon"

' General ability
   SpAbilityName(30) = "Protection"
   SpAbilityName(31) = "Full protection"
   SpAbilityName(32) = "Fire protection"
   SpAbilityName(33) = "Cold protection"
   SpAbilityName(34) = "Potion protection"
   SpAbilityName(35) = "Magic protection"
   SpAbilityName(36) = "Acid protection"
   SpAbilityName(37) = "Skill"
   SpAbilityName(38) = "Strength"
   SpAbilityName(39) = "Dexterity"
   SpAbilityName(40) = "Intelligence"
   SpAbilityName(41) = "Accuracy"
   SpAbilityName(42) = "Thieving"
   SpAbilityName(43) = "Giant strength"
   SpAbilityName(44) = "Lighten object"
   SpAbilityName(45) = "Heavier object"
   SpAbilityName(46) = "Occassional bless"
   SpAbilityName(47) = "Occassional haste"
   SpAbilityName(48) = "Life saving"
   SpAbilityName(49) = "Protect from petrify"
   SpAbilityName(50) = "Regenerate"
   SpAbilityName(51) = "Poison augment"
   SpAbilityName(52) = "Disease party"
   SpAbilityName(53) = "Will"
   SpAbilityName(54) = "Free action"
   SpAbilityName(55) = "Speed"
   SpAbilityName(56) = "Slow wearer"
   SpAbilityName(57) = "Protection from undead"
   SpAbilityName(58) = "Protection from demons"
   SpAbilityName(59) = "Protection from humanoids"
   SpAbilityName(60) = "Protection from reptiles"
   SpAbilityName(61) = "Protection from giants"
   SpAbilityName(62) = "Protection from disease"
   SpAbilityName(63) = "Use to Read"

' Non-Spell usable
   SpAbilityName(70) = "Poison weapon"
   SpAbilityName(71) = "Curse/Bless user"
   SpAbilityName(72) = "Cure/Cause poison"
   SpAbilityName(73) = "Speed/Slow user"
   SpAbilityName(74) = "Add/Lose invulnerability"
   SpAbilityName(75) = "Add/Lose magic resist."
   SpAbilityName(76) = "Add/Lose web"
   SpAbilityName(77) = "Cause/Cure disease"
   SpAbilityName(78) = "Add/Lose sanctuary"
   SpAbilityName(79) = "Cure/Cause dumfound"
   SpAbilityName(80) = "Add/Lose martyr's shield"
   SpAbilityName(81) = "Cure/Cause sleep"
   SpAbilityName(82) = "Cure/Cause paralysis"
   SpAbilityName(83) = "Cure/Cause acid"
   SpAbilityName(84) = "Bliss"
   SpAbilityName(85) = "Add/Lose experience"
   SpAbilityName(86) = "Add/Lose skill points"
   SpAbilityName(87) = "Add/Lose health"
   SpAbilityName(88) = "Add/Lose spell pts"
   SpAbilityName(89) = "Doom"
   SpAbilityName(90) = "Light"
   SpAbilityName(91) = "Stealth"
   SpAbilityName(92) = "Firewalk"
   SpAbilityName(93) = "Flying"
   SpAbilityName(94) = "Major healing"

' Spell usable
   SpAbilityName(110) = "Flame"
   SpAbilityName(111) = "Fireball"
   SpAbilityName(112) = "Firestorm"
   SpAbilityName(113) = "Kill"
   SpAbilityName(114) = "Ice bolt"
   SpAbilityName(115) = "Slow"
   SpAbilityName(116) = "Shockwave"
   SpAbilityName(117) = "Dispel undead"
   SpAbilityName(118) = "Ravage spirit"
   SpAbilityName(119) = "Summoning"
   SpAbilityName(120) = "Mass Summoning"
   SpAbilityName(121) = "Acid spray"
   SpAbilityName(122) = "Stinking cloud"
   SpAbilityName(123) = "Sleep field"
   SpAbilityName(124) = "Venom"
   SpAbilityName(125) = "Shockstorm"
   SpAbilityName(126) = "Paralysis"
   SpAbilityName(127) = "Web spell"
   SpAbilityName(128) = "Strengthen target"
   SpAbilityName(129) = "Quickfire"
   SpAbilityName(130) = "Mass charm"
   SpAbilityName(131) = "Magic map"
   SpAbilityName(132) = "Dispel barrier"
   SpAbilityName(133) = "Make ice wall"
   SpAbilityName(134) = "Charm spell"
   SpAbilityName(135) = "Antimagic cloud"

' Reagents
   SpAbilityName(150) = "Holly/toadstool"
   SpAbilityName(151) = "Comfrey root"
   SpAbilityName(152) = "Glowing nettle"
   SpAbilityName(153) = "Crypt shroom/wormgrass"
   SpAbilityName(154) = "Asptongue mold"
   SpAbilityName(155) = "Ember flowers"
   SpAbilityName(156) = "Graymold"
   SpAbilityName(157) = "Mandrake root"
   SpAbilityName(158) = "Sapphire"
   SpAbilityName(159) = "Smoky crystal"
   SpAbilityName(160) = "Ressurection balm"
   SpAbilityName(161) = "Lockpicks"

' Missiles
   SpAbilityName(170) = "Returning"
   SpAbilityName(171) = "Lightning"
   SpAbilityName(172) = "Exploding"
   SpAbilityName(173) = "Acid"
   SpAbilityName(174) = "Slay undead"
   SpAbilityName(175) = "Slay demon"
   SpAbilityName(176) = "Heal target"
'===============================================================
' Special Node type names
   For IX = 0 To 255
      With SpNodeType(IX)
         .Name = ""
         .MessType = 0
         .PictType = 0
         For IY = 0 To 8
            .Prompt(IY) = "Unused"
            .Range(IY, 0) = 0
            .Range(IY, 1) = 0
            .Choose(IY) = 0
         Next IY
         .Prompt(9) = "Special to jump to"
         For IY = 0 To 2
            .Button(IY) = 0
         Next IY
      End With
   Next IX
' General
   SpNodeType(0).Name = "No Special"

   With SpNodeType(1)
      .Name = "Set Flag"
      .Prompt(0) = "Stuff Done Flag Part A"
      .Choose(0) = 16
      .Prompt(1) = "Stuff Done Flag Part B"
      .Choose(1) = 17
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Prompt(5) = "Value to change to"
      .Button(0) = 1
   End With

   With SpNodeType(2)
      .Name = "Increment Flag"
      .Prompt(0) = "Stuff Done Flag Part A"
      .Choose(0) = 16
      .Prompt(1) = "Stuff Done Flag Part B"
      .Choose(1) = 17
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Increase/Decrease by"
      .Prompt(6) = "0 - increase, 1 - decrease"
   End With

   With SpNodeType(3)
      .Name = "Display Message"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
   End With

   SpNodeType(4).Name = "Secret Passage"

   With SpNodeType(5)
      .Name = "Display Small Message"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
   End With

   With SpNodeType(6)
      .Name = "Flip Flag"
      .Prompt(0) = "Stuff Done Flag Part A"
      .Choose(0) = 16
      .Prompt(1) = "Stuff Done Flag Part B"
      .Choose(1) = 17
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
   End With

   With SpNodeType(7)
      .Name = "Out Block"
      .Prompt(5) = "0 - can enter, 1 - no enter"
      .Prompt(9) = "Special node if not blocked"
   End With

   With SpNodeType(8)
      .Name = "Town Block"
      .Prompt(5) = "0 - can enter, 1 - no enter"
      .Prompt(9) = "Special node if not blocked"
   End With

   With SpNodeType(9)
      .Name = "Combat Block"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(5) = "0 - can enter, 1 - no enter"
      .Prompt(9) = "Special node if not blocked"
   End With

   With SpNodeType(10)
      .Name = "Looking Block"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(9) = "Special node if not blocked"
    End With

   With SpNodeType(11)
      .Name = "Can't Enter"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "0 - can enter, 1 - no enter"
   End With

   With SpNodeType(12)
      .Name = "Change Time"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Number of moves to set forward"
   End With

   With SpNodeType(13)
      .Name = "Start General Timer"
      .Prompt(5) = "Number of moves to set the timer"
      .Prompt(6) = "Special to call when timer runs out"
      .Button(1) = 1
   End With

   With SpNodeType(14)
      .Name = "Play a Sound"
      .Prompt(5) = "Which sound"
      .Choose(5) = 4
   End With
   
   With SpNodeType(15)
      .Name = "Change Horse Possesion"
      .Prompt(5) = "Horse to set (0-29)"
      .Prompt(6) = "0 - not property, 1 - becomes property"
   End With

   With SpNodeType(16)
      .Name = "Change Boat Possesion"
      .Prompt(5) = "Boat to set (0-29)"
      .Prompt(6) = "0 - not property, 1 - becomes property"
   End With

   With SpNodeType(17)
      .Name = "Show/Hide Town"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Town to show/hide"
      .Choose(5) = 15
      .Prompt(6) = "0 - town hidden, 1 - town visible"
   End With

   With SpNodeType(18)
      .Name = "Major Event Has Occurred"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Number of special event (1 - 20)"
   End With

   With SpNodeType(19)
      .Name = "Forced Give"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Item to give"
      .Choose(5) = 1
      .Prompt(6) = "Special if item not given"
      .Button(1) = 1
   End With
   
   With SpNodeType(20)
      .Name = "Buy Items of Type"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Item class to take away"
      .Prompt(6) = "Special to call if no items taken"
      .Button(1) = 1
      .Prompt(7) = "Amount to pay for each item"
   End With

   SpNodeType(21).Name = "Call Global Special"

   With SpNodeType(22)
      .Name = "Set Many Flags"
      .Prompt(0) = "Stuff Done Flag Part A"
      .Choose(0) = 16
      .Prompt(5) = "Value to set the 10 flags to"
   End With

   With SpNodeType(23)
      .Name = "Copy Flag"
      .Prompt(0) = "Stuff Done Flag Part A"
      .Choose(0) = 16
      .Prompt(1) = "Stuff Done Flag Part B"
      .Choose(1) = 17
      .Prompt(5) = "Flag to change to Part A"
      .Choose(5) = 16
      .Prompt(6) = "Flag to change to Part B"
      .Choose(6) = 17
   End With

   With SpNodeType(24)
      .Name = "Ritual of Sancify Block"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(6) = "Special if not casting ritual"
      .Button(1) = 1
   End With

   With SpNodeType(25)
      .Name = "Have a Rest"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Number of moves that pass"
      .Prompt(6) = "Health and spell pts. to give"
   End With

   With SpNodeType(26)
      .Name = "Wandering will fight"
      .Prompt(5) = "0 - no attack, 1 - attack"
   End With

   SpNodeType(27).Name = "End Scenario"
   
   With SpNodeType(28)
      .Name = "Fireball Block"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(6) = "Special if not casting fireball"
      .Button(1) = 1
   End With

   With SpNodeType(29)
      .Name = "Display Graphic"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Left of bitmap"
      .Prompt(6) = "Top of bitmap"
      .Prompt(7) = "Right of bitmap"
      .Prompt(8) = "Bottom of bitmap"
   End With

' One-shots
   With SpNodeType(50)
      .Name = "Give Item"
      .Prompt(0) = "Stuff Done Flag Part A"
      .Choose(0) = 16
      .Prompt(1) = "Stuff Done Flag Part B"
      .Choose(1) = 17
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Item to give"
      .Choose(5) = 1
      .Prompt(6) = "Amount of gold to give"
      .Prompt(7) = "Amount of food to give"
      .Prompt(8) = "Special if item not given"
      .Button(2) = 1
   End With

   With SpNodeType(51)
      .Name = "Give Special Item"
      .Prompt(0) = "Stuff Done Flag Part A"
      .Choose(0) = 16
      .Prompt(1) = "Stuff Done Flag Part B"
      .Choose(1) = 17
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Num. of spec. item to give (0-" & cstScnSpItem & ")"
      .Choose(5) = 14
      .Prompt(6) = "0 - give item, 1 - take away"
   End With

   With SpNodeType(52)
      .Name = "One-Time Do Nothing"
      .Prompt(0) = "Stuff Done Flag Part A"
      .Choose(0) = 16
      .Prompt(1) = "Stuff Done Flag Part B"
      .Choose(1) = 17
   End With

   With SpNodeType(53)
      .Name = "One-Time and Set"
      .Prompt(0) = "Stuff Done Flag Part A"
      .Choose(0) = 16
      .Prompt(1) = "Stuff Done Flag Part B"
      .Choose(1) = 17
   End With

   With SpNodeType(54)
      .Name = "One-Time Text Message"
      .Prompt(0) = "Stuff Done Flag Part A"
      .Choose(0) = 16
      .Prompt(1) = "Stuff Done Flag Part B"
      .Choose(1) = 17
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
   End With

   With SpNodeType(55)
      .Name = "Display Dialog (Dialog pic)"
      .Prompt(0) = "Stuff Done Flag Part A"
      .Choose(0) = 16
      .Prompt(1) = "Stuff Done Flag Part B"
      .Choose(1) = 17
      .Prompt(2) = "Number of first message in dialog"
      .Prompt(3) = "1 - add 'Leave/OK' button, else no"
      .MessType = 1
      .Button(0) = 1
      .Prompt(4) = "Dialog picture number"
      .PictType = 1
      .Prompt(5) = "Label of 2nd button (-1 no button)"
      .Choose(5) = 5
      .Prompt(6) = "Special if button 2 pressed"
      .Button(1) = 1
      .Prompt(7) = "Label of 3rd button (-1 no button)"
      .Choose(7) = 5
      .Prompt(8) = "Special if button 3 pressed"
      .Button(2) = 1
   End With

   With SpNodeType(56)
      .Name = "Display Dialog (Terrain pic)"
      .Prompt(0) = "Stuff Done Flag Part A"
      .Choose(0) = 16
      .Prompt(1) = "Stuff Done Flag Part B"
      .Choose(1) = 17
      .Prompt(2) = "Number of first message in dialog"
      .Prompt(3) = "1 - add 'Leave/OK' button, else no"
      .MessType = 1
      .Button(0) = 1
      .Prompt(4) = "Terrain picture number"
      .PictType = 2
      .Prompt(5) = "Label of 2nd button (-1 no button)"
      .Choose(5) = 5
      .Prompt(6) = "Special if button 2 pressed"
      .Button(1) = 1
      .Prompt(7) = "Label of 3rd button (-1 no button)"
      .Choose(7) = 5
      .Prompt(8) = "Special if button 3 pressed"
      .Button(2) = 1
   End With

   With SpNodeType(57)
      .Name = "Display Dialog (Monster pic)"
      .Prompt(0) = "Stuff Done Flag Part A"
      .Choose(0) = 16
      .Prompt(1) = "Stuff Done Flag Part B"
      .Choose(1) = 17
      .Prompt(2) = "Number of first message in dialog"
      .Prompt(3) = "1 - add 'Leave/OK' button, else no"
      .MessType = 1
      .Button(0) = 1
      .Prompt(4) = "Monster picture number"
      .PictType = 3
      .Prompt(5) = "Label of 2nd button (-1 no button)"
      .Choose(5) = 5
      .Prompt(6) = "Special if button 2 pressed"
      .Button(1) = 1
      .Prompt(7) = "Label of 3rd button (-1 no button)"
      .Choose(7) = 5
      .Prompt(8) = "Special if button 3 pressed"
      .Button(2) = 1
   End With

   With SpNodeType(58)
      .Name = "Give Item (Dialog pic)"
      .Prompt(0) = "Stuff Done Flag Part A"
      .Choose(0) = 16
      .Prompt(1) = "Stuff Done Flag Part B"
      .Choose(1) = 17
      .Prompt(2) = "Number of first message in dialog"
      .Prompt(3) = "Num. of spec. item to give (-1 none)"
      .Choose(3) = 14
      .MessType = 1
      .Button(0) = 1
      .Prompt(4) = "Dialog picture number"
      .PictType = 1
      .Prompt(5) = "Item to give"
      .Choose(5) = 1
      .Prompt(6) = "Amount of gold to give"
      .Prompt(7) = "Amount of food to give"
      .Prompt(8) = "Special if item is taken"
      .Button(2) = 1
   End With

   With SpNodeType(59)
      .Name = "Give Item (Terrain pic)"
      .Prompt(0) = "Stuff Done Flag Part A"
      .Choose(0) = 16
      .Prompt(1) = "Stuff Done Flag Part B"
      .Choose(1) = 17
      .Prompt(2) = "Number of first message in dialog"
      .Prompt(3) = "Num. of spec. item to give (-1 none)"
      .Choose(3) = 14
      .MessType = 1
      .Button(0) = 1
      .Prompt(4) = "Terrain picture number"
      .PictType = 2
      .Prompt(5) = "Item to give"
      .Choose(5) = 1
      .Prompt(6) = "Amount of gold to give"
      .Prompt(7) = "Amount of food to give"
      .Prompt(8) = "Special if item is taken"
      .Button(2) = 1
   End With

   With SpNodeType(60)
      .Name = "Give Item (Monster pic)"
      .Prompt(0) = "Stuff Done Flag Part A"
      .Choose(0) = 16
      .Prompt(1) = "Stuff Done Flag Part B"
      .Choose(1) = 17
      .Prompt(2) = "Number of first message in dialog"
      .Prompt(3) = "Num. of spec. item to give (-1 none)"
      .Choose(3) = 14
      .MessType = 1
      .Button(0) = 1
      .Prompt(4) = "Monster picture number"
      .PictType = 3
      .Prompt(5) = "Item to give"
      .Choose(5) = 1
      .Prompt(6) = "Amount of gold to give"
      .Prompt(7) = "Amount of food to give"
      .Prompt(8) = "Special if item is taken"
      .Button(2) = 1
   End With

   With SpNodeType(61)
      .Name = "One-Time Place Outdoor Enc."
      .Prompt(0) = "Stuff Done Flag Part A"
      .Choose(0) = 16
      .Prompt(1) = "Stuff Done Flag Part B"
      .Choose(1) = 17
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Special outdoor enc. to place (0-3)"
   End With

   With SpNodeType(62)
      .Name = "One-Time Place Town Enc."
      .Prompt(0) = "Stuff Done Flag Part A"
      .Choose(0) = 16
      .Prompt(1) = "Stuff Done Flag Part B"
      .Choose(1) = 17
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Spec. enc. code to activate (0-9)"
   End With
   
   With SpNodeType(63)
      .Name = "Trap"
      .Prompt(0) = "Stuff Done Flag Part A"
      .Choose(0) = 16
      .Prompt(1) = "Stuff Done Flag Part B"
      .Choose(1) = 17
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Type of Trap"
      .Choose(5) = 10
      .Prompt(6) = "Trap severity (0-3)"
      .Prompt(7) = "Penalty (0-100, higher is harder)"
   End With
   
   
' Affect PCs
   With SpNodeType(80)
      .Name = "Select a PC"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "0 - only living, 1 - any PC"
      .Prompt(6) = "Special if Cancel button pressed"
      .Button(1) = 1
   End With

   With SpNodeType(81)
      .Name = "Do Damage"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Number of dice"
      .Prompt(6) = "Number of 'sides' on dice"
      .Prompt(7) = "Amount of extra damage"
      .Prompt(8) = "Type of damage"
      .Choose(8) = 11
   End With

   With SpNodeType(82)
      .Name = "Affect Health"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Amount"
      .Prompt(6) = "0 - raise, 1 - lower"
   End With

   With SpNodeType(83)
      .Name = "Affect Spell Points"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Amount"
      .Prompt(6) = "0 - raise, 1 - lower"
   End With

   With SpNodeType(84)
      .Name = "Affect Experience"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Amount (0-100)"
      .Prompt(6) = "0 - raise, 1 - lower"
   End With

   With SpNodeType(85)
      .Name = "Affect Skill Points"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Amount (0-10)"
      .Prompt(6) = "0 - raise, 1 - lower"
   End With

   With SpNodeType(86)
      .Name = "Kill/Raise Dead"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "0 - dead, 1 - dust, 2 - stoned"
      .Prompt(6) = "0 - raise dead, 1 - hurt"
   End With

   With SpNodeType(87)
      .Name = "Affect Poison"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Amount (0 - 8)"
      .Prompt(6) = "0 - cure, 1 - inflict"
   End With

   With SpNodeType(88)
      .Name = "Affect Slow/Haste"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Amount (0 - 8)"
      .Prompt(6) = "0 - cure, 1 - inflict"
   End With

   With SpNodeType(89)
      .Name = "Affect Invulnerability"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Amount (0 - 8)"
      .Prompt(6) = "0 - cure, 1 - inflict"
   End With

   With SpNodeType(90)
      .Name = "Affect Magic Resistance"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Amount (0 - 8)"
      .Prompt(6) = "0 - cure, 1 - inflict"
   End With

   With SpNodeType(91)
      .Name = "Affect Webs"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Amount (0 - 8)"
      .Prompt(6) = "0 - cure, 1 - inflict"
   End With

   With SpNodeType(92)
      .Name = "Affect Disease"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Amount (0 - 8)"
      .Prompt(6) = "0 - cure, 1 - inflict"
   End With

   With SpNodeType(93)
      .Name = "Affect Sanctuary"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Amount (0 - 8)"
      .Prompt(6) = "0 - adds, 1 - removes"
   End With

   With SpNodeType(94)
      .Name = "Affect Curse/Bless"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Amount (0 - 8)"
      .Prompt(6) = "0 - curses, 1 - blesses"
   End With

   With SpNodeType(95)
      .Name = "Affect Dumfounding"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Amount (0 - 8)"
      .Prompt(6) = "0 - cure, 1 - inflict"
   End With

   With SpNodeType(96)
      .Name = "Affect Sleep"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Amount (0 - 8)"
      .Prompt(6) = "0 - cure, 1 - inflict"
   End With

   With SpNodeType(97)
      .Name = "Affect Paralysis"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Amount (0 - 5000)"
      .Prompt(6) = "0 - cure, 1 - inflict"
   End With

   With SpNodeType(98)
      .Name = "Affect Statistic"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(4) = "Chance of changing (0 - 100)"
      .Prompt(5) = "Amount (0 - 10)"
      .Prompt(6) = "0 - increase, 1 - decrease"
      .Prompt(7) = "Statistic to adjust"
      .Choose(7) = 6
   End With

   With SpNodeType(99)
      .Name = "Give Mage Spell"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Which spell"
      .Choose(5) = 7
   End With

   With SpNodeType(100)
      .Name = "Give Priest Spell"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Which spell"
      .Choose(5) = 8
   End With

   With SpNodeType(101)
      .Name = "Affect Gold"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Amount (0 - 25000)"
      .Prompt(6) = "0 - increase, 1 - decrease"
   End With

   With SpNodeType(102)
      .Name = "Affect Food"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Amount (0 - 25000)"
      .Prompt(6) = "0 - increase, 1 - decrease"
   End With

   With SpNodeType(103)
      .Name = "Affect Alchemy"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Which recipe"
      .Choose(5) = 9
   End With

   With SpNodeType(104)
      .Name = "Affect Stealth"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Amount (0 - 250)"
   End With

   With SpNodeType(105)
      .Name = "Affect Firewalk"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Amount (0 - 250)"
   End With

   With SpNodeType(106)
      .Name = "Affect Flying"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Amount (0 - 250)"
   End With

' If-Thens
   With SpNodeType(130)
      .Name = "Stuff Done Flag?"
      .Prompt(0) = "Stuff Done Flag Part A"
      .Choose(0) = 16
      .Prompt(1) = "Stuff Done Flag Part B"
      .Choose(1) = 17
      .Prompt(5) = "If at least this value ..."
      .Prompt(6) = "Call this special ..."
      .Button(1) = 1
      .Prompt(7) = "If less than this value ..."
      .Prompt(8) = "Call this special ..."
      .Button(2) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

   With SpNodeType(131)
      .Name = "Town Number?"
      .Prompt(0) = "Stuff Done Flag Part A"
      .Choose(0) = 16
      .Prompt(1) = "Stuff Done Flag Part B"
      .Choose(1) = 17
      .Prompt(5) = "If in this town ..."
      .Choose(5) = 15
      .Prompt(6) = "Call this special ..."
      .Button(1) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

   With SpNodeType(132)
      .Name = "Random Number?"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(5) = "If random # (1 - 100) less than ..."
      .Prompt(6) = "Call this special ..."
      .Button(1) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

   With SpNodeType(133)
      .Name = "Have Special Item?"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(5) = "If has spec. item"
      .Choose(5) = 14
      .Prompt(6) = "Call this special ..."
      .Button(1) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

   With SpNodeType(134)
      .Name = "Stuff Done Compare?"
      .Prompt(0) = "Stuff Done Flag Part A"
      .Choose(0) = 16
      .Prompt(1) = "Stuff Done Flag Part B"
      .Choose(1) = 17
      .Prompt(5) = "Stuff Done Flag 2 Part A"
      .Choose(5) = 16
      .Prompt(6) = "Stuff Done Flag 2 Part B"
      .Choose(6) = 17
      .Prompt(8) = "Call this special if second flag lower"
      .Button(2) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

   With SpNodeType(135)
      .Name = "Terrain this Type? (town)"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(5) = "X coordinate of space"
      .Prompt(6) = "Y coordinate of space"
      .Prompt(7) = "If space is this terrain type ..."
      .Choose(7) = 2
      .Prompt(8) = "Call this special ..."
      .Button(2) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

   With SpNodeType(136)
      .Name = "Terrain this Type? (out)"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(5) = "X coordinate of space"
      .Prompt(6) = "Y coordinate of space"
      .Prompt(7) = "If space is this terrain type ..."
      .Choose(7) = 2
      .Prompt(8) = "Call this special ..."
      .Button(2) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

   With SpNodeType(137)
      .Name = "Has Gold?"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(5) = "If party has this much gold ..."
      .Prompt(6) = "Call this special ..."
      .Button(1) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

   With SpNodeType(138)
      .Name = "Has Food?"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(5) = "If party has this much food ..."
      .Prompt(6) = "Call this special ..."
      .Button(1) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

   With SpNodeType(139)
      .Name = "Item Class on Space?"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(5) = "X coordinate of space"
      .Prompt(6) = "Y coordinate of space"
      .Prompt(7) = "If item of this class on space ..."
      .Prompt(8) = "Call this special ..."
      .Button(2) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

   With SpNodeType(140)
      .Name = "Have Item with Class?"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(5) = "If has item of this special class ..."
      .Prompt(6) = "Call this special ..."
      .Button(1) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

   With SpNodeType(141)
      .Name = "Equipped Item with Class?"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(5) = "If has equipped item of this sp. class ..."
      .Prompt(6) = "Call this special ..."
      .Button(1) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

   With SpNodeType(142)
      .Name = "Has Gold? (+ take)"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(5) = "If party has this much gold ..."
      .Prompt(6) = "Call this special ..."
      .Button(1) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

   With SpNodeType(143)
      .Name = "Has Food? (+ take)"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(5) = "If party has this much food ..."
      .Prompt(6) = "Call this special ..."
      .Button(1) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

   With SpNodeType(144)
      .Name = "Item Class on Space? (+ take)"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(5) = "X coordinate of space"
      .Prompt(6) = "Y coordinate of space"
      .Prompt(7) = "If item of this class on space ..."
      .Prompt(8) = "Call this special ..."
      .Button(2) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

   With SpNodeType(145)
      .Name = "Have Item W. Class? (+ take)"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(5) = "If has item of this special class ..."
      .Prompt(6) = "Call this special ..."
      .Button(1) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

   With SpNodeType(146)
      .Name = "Equip Item W. Class? (+ take)"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(5) = "If has equipped item of this sp. class ..."
      .Prompt(6) = "Call this special ..."
      .Button(1) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

   With SpNodeType(147)
      .Name = "Day Reached?"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(5) = "If this day has been reached ..."
      .Prompt(6) = "Call this special ..."
      .Button(1) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

   With SpNodeType(148)
      .Name = "Any Barrels?"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(6) = "If any barrels, call this special ..."
      .Button(1) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

   With SpNodeType(149)
      .Name = "Any Crates?"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(6) = "If any crates, call this special ..."
      .Button(1) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

   With SpNodeType(150)
      .Name = "Special Thing Happened?"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(5) = "If this day has been reached ..."
      .Prompt(6) = "And this event didn't happen before it ..."
      .Prompt(8) = "Call this special ..."
      .Button(2) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

   With SpNodeType(151)
      .Name = "Has Cave Lore?"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(6) = "If any Cave Lore, call this special ..."
      .Button(1) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

   With SpNodeType(152)
      .Name = "Has Woodsman?"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(6) = "If any Woodsman, call this special ..."
      .Button(1) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

   With SpNodeType(153)
      .Name = "Has Enough Mage Lore?"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(5) = "If party has this much Mage Lore ..."
      .Prompt(6) = "Call this special ..."
      .Button(1) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

   With SpNodeType(154)
      .Name = "Text Response?"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(5) = "Number of a SCENARIO special message"
      .Prompt(6) = "If answer matches, call this special ..."
      .Button(1) = 1
      .Prompt(7) = "Number of a SCENARIO special message"
      .Prompt(8) = "If answer matches, call this special ..."
      .Button(2) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

   With SpNodeType(155)
      .Name = "Stuff Done Equal?"
      .Prompt(0) = "Stuff Done Flag Part A"
      .Choose(0) = 16
      .Prompt(1) = "Stuff Done Flag Part B"
      .Choose(1) = 17
      .Prompt(5) = "If flag has this value ..."
      .Prompt(6) = "Call this special ..."
      .Button(1) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With
   
   With SpNodeType(156)
      .Name = "Item Identified?"
      .Choose(0) = 16
      .Choose(1) = 17
      .Prompt(6) = "If item is identified call this special ..."
      .Button(1) = 1
      .Prompt(9) = "Otherwise call this special ..."
   End With

' Town Specs
   With SpNodeType(170)
      .Name = "Town Hostile"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Prompt(5) = "1 - reset, otherwise set"
      .Button(0) = 1
   End With

   With SpNodeType(171)
      .Name = "Change Terrain"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "X coordinate of space"
      .Prompt(6) = "Y coordinate of space"
      .Prompt(7) = "Terrain to change to"
      .Choose(7) = 2
   End With

   With SpNodeType(172)
      .Name = "Swap Terrain"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "X coordinate of space"
      .Prompt(6) = "Y coordinate of space"
      .Prompt(7) = "Swap this terrain ..."
      .Choose(7) = 2
      .Prompt(8) = "With this terrain ..."
      .Choose(8) = 2
   End With

   With SpNodeType(173)
      .Name = "Transform Terrain"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "X coordinate of space"
      .Prompt(6) = "Y coordinate of space"
   End With

   With SpNodeType(174)
      .Name = "Move Party"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "X coordinate of space"
      .Prompt(6) = "Y coordinate of space"
      .Prompt(7) = "0 - Just move, 1 - Teleport"
   End With

   With SpNodeType(175)
      .Name = "Hit Space"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "X coordinate of space"
      .Prompt(6) = "Y coordinate of space"
      .Prompt(7) = "Damage to inflict (0 - 1000)"
   End With

   With SpNodeType(176)
      .Name = "Explosion on Space"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(4) = "Radius of explosion"
      .Prompt(5) = "X coordinate of space"
      .Prompt(6) = "Y coordinate of space"
      .Prompt(7) = "Damage to inflict (0 - 1000)"
      .Prompt(8) = "Type of damage"
      .Choose(8) = 11
   End With

   With SpNodeType(177)
      .Name = "Lock Space"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "X coordinate of space"
      .Prompt(6) = "Y coordinate of space"
   End With

   With SpNodeType(178)
      .Name = "Unlock Space"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "X coordinate of space"
      .Prompt(6) = "Y coordinate of space"
   End With

   With SpNodeType(179)
      .Name = "Do sfx Burst"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "X coordinate of space"
      .Prompt(6) = "Y coordinate of space"
      .Prompt(7) = "0 - fire, 1 - electricity, 2 - teleport"
   End With

   With SpNodeType(180)
      .Name = "Make Wandering Monster"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
   End With

   With SpNodeType(181)
      .Name = "Place Monster"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "X coordinate of space"
      .Prompt(6) = "Y coordinate of space"
      .Prompt(7) = "Number of creature to place"
      .Choose(7) = 3
      .Prompt(8) = "0 - don't force, 1 - force"
   End With

   With SpNodeType(182)
      .Name = "Destroy Monster"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Type of creature to remove"
      .Choose(5) = 3
   End With

   With SpNodeType(183)
      .Name = "Destroy All Monsters"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "0 - all, 1 - friendly, 2 - hostile"
   End With

   With SpNodeType(184)
      .Name = "Generic Lever"
      .Prompt(6) = "If Pulled, call this special ..."
      .Button(1) = 1
   End With

   With SpNodeType(185)
      .Name = "Generic Portal"
      .Prompt(5) = "X coordinate to teleport to"
      .Prompt(6) = "Y coordinate to teleport to"
   End With

   With SpNodeType(186)
      .Name = "Generic Button"
      .Prompt(6) = "If Pushed, call this special ..."
      .Button(1) = 1
   End With

   With SpNodeType(187)
      .Name = "Generic Stairway"
      .Prompt(5) = "X coordinate to go to"
      .Prompt(6) = "Y coordinate to go to"
      .Prompt(7) = "Number of town to place party in"
      .Choose(7) = 15
      .Prompt(8) = "What text? (see docs, 0 - up, 1 - down)"
   End With

   With SpNodeType(188)
      .Name = "Lever"
      .Prompt(2) = "Number of first message in dialog"
      .MessType = 1
      .Button(0) = 1
      .PictType = 2
      .Prompt(6) = "If Pulled, call this special ..."
      .Button(1) = 1
   End With

   With SpNodeType(189)
      .Name = "Portal"
      .Prompt(2) = "Number of first message in dialog"
      .MessType = 1
      .Button(0) = 1
      .PictType = 2
      .Prompt(5) = "X coordinate to teleport to"
      .Prompt(6) = "Y coordinate to teleport to"
   End With

   With SpNodeType(190)
      .Name = "Stairway"
      .Prompt(2) = "Number of first message in dialog"
      .MessType = 1
      .Button(0) = 1
      .Prompt(5) = "X coordinate to go to"
      .Prompt(6) = "Y coordinate to go to"
      .Prompt(7) = "Number of town to place party in"
      .Choose(7) = 15
      .Prompt(8) = "If 1, always change level"
   End With

   With SpNodeType(191)
      .Name = "Relocate Outdoors"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "X coordinate of outdoor section"
      .Prompt(6) = "Y coordinate of outdoor section"
      .Prompt(7) = "X coordinate inside section"
      .Prompt(8) = "Y coordinate inside section"
   End With

   With SpNodeType(192)
      .Name = "Place Item"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "X coordinate to place at"
      .Prompt(6) = "Y coordinate to place at"
      .Prompt(7) = "Item to place"
      .Choose(7) = 1
   End With

   With SpNodeType(193)
      .Name = "Split Party"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "X coordinate to place lone PC at"
      .Prompt(6) = "Y coordinate to place lone PC at"
      .Prompt(7) = "0 - no telep. noise, 1 - play telep. noise"
   End With

   With SpNodeType(194)
      .Name = "Reunite Party"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "0 - no telep. noise, 1 - play telep. noise"
   End With

   With SpNodeType(195)
      .Name = "Start General Timer"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Number of moves until event"
      .Prompt(6) = "Call this special when timer runs out ..."
      .Button(1) = 1
   End With

   With SpNodeType(196)
      .Name = "Set Town Lighting"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Select lighting"
      .Choose(5) = 13
   End With

   For IX = 197 To 199
      SpNodeType(IX).Name = "Unused"
   Next IX
   
   With SpNodeType(200)
      .Name = "Place Fire Wall"
      .Prompt(0) = "Chance of placing (0 - 100)"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Top of rectangle"
      .Prompt(6) = "Left of rectangle"
      .Prompt(7) = "Bottom of rectangle"
      .Prompt(8) = "Right of rectangle"
   End With

   With SpNodeType(201)
      .Name = "Place Force Wall"
      .Prompt(0) = "Chance of placing (0 - 100)"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Top of rectangle"
      .Prompt(6) = "Left of rectangle"
      .Prompt(7) = "Bottom of rectangle"
      .Prompt(8) = "Right of rectangle"
   End With

   With SpNodeType(202)
      .Name = "Place Ice Wall"
      .Prompt(0) = "Chance of placing (0 - 100)"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Top of rectangle"
      .Prompt(6) = "Left of rectangle"
      .Prompt(7) = "Bottom of rectangle"
      .Prompt(8) = "Right of rectangle"
   End With

   With SpNodeType(203)
      .Name = "Place Blade Wall"
      .Prompt(0) = "Chance of placing (0 - 100)"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Top of rectangle"
      .Prompt(6) = "Left of rectangle"
      .Prompt(7) = "Bottom of rectangle"
      .Prompt(8) = "Right of rectangle"
   End With

   With SpNodeType(204)
      .Name = "Place Stinking Cloud"
      .Prompt(0) = "Chance of placing (0 - 100)"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Top of rectangle"
      .Prompt(6) = "Left of rectangle"
      .Prompt(7) = "Bottom of rectangle"
      .Prompt(8) = "Right of rectangle"
   End With

   With SpNodeType(205)
      .Name = "Place Sleep Field"
      .Prompt(0) = "Chance of placing (0 - 100)"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Top of rectangle"
      .Prompt(6) = "Left of rectangle"
      .Prompt(7) = "Bottom of rectangle"
      .Prompt(8) = "Right of rectangle"
   End With

   With SpNodeType(206)
      .Name = "Place Quickfire"
      .Prompt(0) = "Chance of placing (0 - 100)"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Top of rectangle"
      .Prompt(6) = "Left of rectangle"
      .Prompt(7) = "Bottom of rectangle"
      .Prompt(8) = "Right of rectangle"
   End With

   With SpNodeType(207)
      .Name = "Place Fire Barrier"
      .Prompt(0) = "Chance of placing (0 - 100)"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Top of rectangle"
      .Prompt(6) = "Left of rectangle"
      .Prompt(7) = "Bottom of rectangle"
      .Prompt(8) = "Right of rectangle"
   End With

   With SpNodeType(208)
      .Name = "Place Force Barrier"
      .Prompt(0) = "Chance of placing (0 - 100)"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Top of rectangle"
      .Prompt(6) = "Left of rectangle"
      .Prompt(7) = "Bottom of rectangle"
      .Prompt(8) = "Right of rectangle"
   End With

   With SpNodeType(209)
      .Name = "Cleanse Rectangle"
      .Prompt(0) = "0 - Leave barriers, boxes, etc."
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Top of rectangle"
      .Prompt(6) = "Left of rectangle"
      .Prompt(7) = "Bottom of rectangle"
      .Prompt(8) = "Right of rectangle"
   End With

   With SpNodeType(210)
      .Name = "Place sfx"
      .Prompt(0) = "Chance of placing (0 - 100)"
      .Prompt(1) = "What to place (see docs)"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Top of rectangle"
      .Prompt(6) = "Left of rectangle"
      .Prompt(7) = "Bottom of rectangle"
      .Prompt(8) = "Right of rectangle"
   End With

   With SpNodeType(211)
      .Name = "Place Barrels, etc"
      .Prompt(0) = "Chance of placing (0 - 100)"
      .Prompt(1) = "0 - web, 1 - barrel, 2 - crate"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Top of rectangle"
      .Prompt(6) = "Left of rectangle"
      .Prompt(7) = "Bottom of rectangle"
      .Prompt(8) = "Right of rectangle"
   End With

   With SpNodeType(212)
      .Name = "Move Items"
      .Prompt(0) = "X of space to move to"
      .Prompt(1) = "Y of space to move to"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Top of rectangle"
      .Prompt(6) = "Left of rectangle"
      .Prompt(7) = "Bottom of rectangle"
      .Prompt(8) = "Right of rectangle"
   End With

   With SpNodeType(213)
      .Name = "Destroy Items"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Top of rectangle"
      .Prompt(6) = "Left of rectangle"
      .Prompt(7) = "Bottom of rectangle"
      .Prompt(8) = "Right of rectangle"
   End With

   With SpNodeType(214)
      .Name = "Change Rectangle Terrain"
      .Prompt(0) = "Terrain to change to"
      .Choose(0) = 2
      .Prompt(1) = "Percent chance of changing (0 - 100)"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Top of rectangle"
      .Prompt(6) = "Left of rectangle"
      .Prompt(7) = "Bottom of rectangle"
      .Prompt(8) = "Right of rectangle"
   End With

   With SpNodeType(215)
      .Name = "Swap Rectangle Terrain"
      .Prompt(0) = "Switch this terrain type"
      .Choose(0) = 2
      .Prompt(1) = "With this terrain type"
      .Choose(1) = 2
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Top of rectangle"
      .Prompt(6) = "Left of rectangle"
      .Prompt(7) = "Bottom of rectangle"
      .Prompt(8) = "Right of rectangle"
   End With

   With SpNodeType(216)
      .Name = "Transform Rectangle Terrain"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Top of rectangle"
      .Prompt(6) = "Left of rectangle"
      .Prompt(7) = "Bottom of rectangle"
      .Prompt(8) = "Right of rectangle"
   End With

   With SpNodeType(217)
      .Name = "Lock Rectangle"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Top of rectangle"
      .Prompt(6) = "Left of rectangle"
      .Prompt(7) = "Bottom of rectangle"
      .Prompt(8) = "Right of rectangle"
   End With

   With SpNodeType(218)
      .Name = "Unlock Rectangle"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Top of rectangle"
      .Prompt(6) = "Left of rectangle"
      .Prompt(7) = "Bottom of rectangle"
      .Prompt(8) = "Right of rectangle"
   End With
   
' Out Specs
   SpNodeType(225).Name = "Make Outdoor Wandering"

   With SpNodeType(226)
      .Name = "Change Outdoor Terrain"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "X coordinate of space"
      .Prompt(6) = "Y coordinate of space"
      .Prompt(7) = "Terrain to change to"
      .Choose(7) = 2
   End With

   With SpNodeType(227)
      .Name = "Place Outdoor Encounter"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Number of special encounter (0 - 3)"
   End With

   With SpNodeType(228)
      .Name = "Outdoor Move Party"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "X coordinate of space"
      .Prompt(6) = "Y coordinate of space"
   End With

   With SpNodeType(229)
      .Name = "Outdoor Store"
      .Prompt(2) = "First part of message"
      .Prompt(3) = "Second part of message"
      .Button(0) = 1
      .Prompt(5) = "Type of store"
      .Choose(5) = 12
'      .Prompt(6) = "Number of first item in store"
'      .Choose(6) = 1
'      .Prompt(7) = "Number of items in store (1 - 40)"
'      .Prompt(8) = "Cost adjust (0 - 6, lower = cheaper)"
   End With
'===============================================================
' Sound names
   SoundName(0) = "High Beep"
   SoundName(1) = "Low Beep"
   SoundName(2) = "Sword Swish"
   SoundName(3) = "Cough"
   SoundName(4) = "Bless noise"
   SoundName(5) = "Explosion"
   SoundName(6) = "Chewing"
   SoundName(7) = "Cool"
   SoundName(8) = "Bubbles"
   SoundName(9) = "Lock click"
   SoundName(10) = "Teleportation sound"
   SoundName(11) = "3 Fast Booms"
   SoundName(12) = "Longbow"
   SoundName(13) = "Party death sound"
   SoundName(14) = "Thrown missile"
   SoundName(15) = "Cash register"
   SoundName(16) = "Town entry"
   SoundName(17) = "Short cough"
   SoundName(18) = "Drawing sword"
   SoundName(19) = "Sword swish"
   SoundName(20) = "Yawn"
   SoundName(21) = "PC Dying"
   SoundName(22) = "Opening music (You cant call this sound)"
   SoundName(23) = "Start outdoor combat"
   SoundName(24) = "Cast priest spell"
   SoundName(25) = "Cast mage spell"
   SoundName(26) = "Gremlin laugh"
   SoundName(27) = "Monster dying 1"
   SoundName(28) = "Waterfall"
   SoundName(29) = "Monster dying 2"
   SoundName(30) = "Monster dying 3"
   SoundName(31) = "Monster dying 4"
   SoundName(32) = "Getting hit 1"
   SoundName(33) = "Getting hit 2"
   SoundName(34) = "Button press 1"
   SoundName(35) = "Spider Hi"
   SoundName(36) = "SpiderHello"
   SoundName(37) = "Button press 2"
   SoundName(38) = "Coin on counter"
   SoundName(39) = "Coins jingling"
   SoundName(40) = "Thank you"
   SoundName(41) = "Darn"
   SoundName(42) = "Dang"
   SoundName(43) = "Stoning noise"
   SoundName(44) = "Monster breathe"
   SoundName(45) = "On who?"
   SoundName(46) = "Growl"
   SoundName(47) = "Walk - gravel"
   SoundName(48) = "Boat move"
   SoundName(49) = "Step 1"
   SoundName(50) = "Step 2"
   SoundName(51) = "Magic noise 1"
   SoundName(52) = "Magic noise 2"
   SoundName(53) = "Magic noise 3"
   SoundName(54) = "Scream"
   SoundName(55) = "Walk - squish"
   SoundName(56) = "Swallow"
   SoundName(57) = "Special noise"
   SoundName(58) = "Open door"
   SoundName(59) = "Close door"
   SoundName(60) = "Small boom"
   SoundName(61) = "Summoning"
   SoundName(62) = "Mmmmmm."
   SoundName(63) = "Ow"
   SoundName(64) = "Spit"
   SoundName(65) = "Draining noise"
   SoundName(66) = "Disease"
   SoundName(67) = "Huh?"
   SoundName(68) = "Identify noise"
   SoundName(69) = "Sword 1"
   SoundName(70) = "Sword 2"
   SoundName(71) = "Sword 3"
   SoundName(72) = "Club"
   SoundName(73) = "Fire impact"
   SoundName(74) = "Fireball swoosh"
   SoundName(75) = "Cold damage"
   SoundName(76) = "Chirp 1"
   SoundName(77) = "Chirp 2"
   SoundName(78) = "Drip 1"
   SoundName(79) = "Drip 2"
   SoundName(80) = "Bark"
   SoundName(81) = "Meow"
   SoundName(82) = "Baa"
   SoundName(83) = "Moo"
   SoundName(84) = "Neigh"
   SoundName(85) = "Gallop"
   SoundName(86) = "Attack - Claw"
   SoundName(87) = "Attack - Bite"
   SoundName(88) = "Attack - Slime"
   SoundName(89) = "Attack - Zap"
   SoundName(90) = "Paralyze"
   SoundName(91) = "Chirp 3"
   SoundName(92) = "Chicken"
   SoundName(93) = "Sheathe sword"
   SoundName(94) = "Lever"
   SoundName(95) = "Enter dungeon"
   SoundName(96) = "Sleep"
   SoundName(97) = "Damage - Uh"
   SoundName(98) = "Missile hit"
   SoundName(99) = "No sound"
'===============================================================
' Enhantments for weapons
   EnchantName(0) = "+1"
   EnchantName(1) = "+2"
   EnchantName(2) = "+3"
   EnchantName(3) = "Shoot flame spells"
   EnchantName(4) = "Flaming weapon"
   EnchantName(5) = "+5"
   EnchantName(6) = "Blessed"
'===============================================================
' Trap names
   TrapName(0) = "Randomly selected"
   TrapName(1) = "Damage 1 character"
   TrapName(2) = "Poison 1 character"
   TrapName(3) = "Poison party"
   TrapName(4) = "Damage party"
   TrapName(5) = "Paralyze character"
   TrapName(6) = "No trap after all"
   TrapName(7) = "Drain experience"
   TrapName(8) = "Make town hostile"
   TrapName(9) = "Fire damage 1 character"
   TrapName(10) = "Dumbfound 1 character"
   TrapName(11) = "Disease 1 character"
   TrapName(12) = "Disease party"
   TrapName(13) = "Dumbfound party"
'===============================================================
' Explosion on space types
   ExplosionName(0) = "Weapon"
   ExplosionName(1) = "Fire"
   ExplosionName(2) = "Poison"
   ExplosionName(3) = "General magic"
   ExplosionName(4) = "Unblockable"
   ExplosionName(5) = "Cold"
   ExplosionName(6) = "Demon"
   ExplosionName(7) = "Undead"
End Sub

Public Sub InitMapData()
   Dim IX As Integer
   Dim IY As Integer
   Dim IDX As Integer
   Dim IDY As Integer
   Dim NDX As Integer
   Dim MapX As Integer
   Dim MapY As Integer
   
   Select Case MapContext
   Case 0   ' Lg town
      MapSize = 63
      MapCenter(0) = 32
      MapCenter(1) = 32
      MapLimit(0) = 0
      MapLimit(1) = 63
      MapRange(0) = 4
      MapRange(1) = 4
      MapRange(2) = 59
      MapRange(3) = 59
   Case 1   ' Md town
      MapSize = 47
      MapCenter(0) = 24
      MapCenter(1) = 24
      MapLimit(0) = 0
      MapLimit(1) = 47
      MapRange(0) = 4
      MapRange(1) = 4
      MapRange(2) = 43
      MapRange(3) = 43
   Case 2   ' Sm town
      MapSize = 31
      MapCenter(0) = 16
      MapCenter(1) = 16
      MapLimit(0) = 0
      MapLimit(1) = 31
      MapRange(0) = 4
      MapRange(1) = 4
      MapRange(2) = 27
      MapRange(3) = 27
   Case 3   ' Outside
      MapSize = 49
      MapCenter(0) = 25
      MapCenter(1) = 25
      MapLimit(0) = 1
      MapLimit(1) = 48
      MapRange(0) = 4
      MapRange(1) = 4
      MapRange(2) = 45
      MapRange(3) = 45
   End Select
   ReDim MapData(MapSize, MapSize)
   Select Case MapContext
   Case 0, 1, 2
      With TownData(CurTown)
      For IX = 0 To MapSize
         For IY = 0 To MapSize
            MapData(IX, IY).Terrain = .Map(IX, IY)
            MapData(IX, IY).Special = -1
            MapData(IX, IY).Sign = -1
            MapData(IX, IY).Transport = -1
            For NDX = 0 To 13
               MapData(IX, IY).Field(NDX) = -1
            Next NDX
            MapData(IX, IY).NItems = -1
         Next IY
      Next IX
      If CurTown = Scen.StartTownNum Then
         MapData(Scen.StartTownCoord(0), Scen.StartTownCoord(1)).Flags(0) = True
      End If
      For NDX = 0 To 3
         If .WanderingLoc(NDX).Loc(0) <> 100 Then
            IX = .WanderingLoc(NDX).Loc(0)
            IY = .WanderingLoc(NDX).Loc(1)
            MapData(IX, IY).Flags(1) = True
         End If
      Next NDX
      For NDX = 0 To 3
         IX = .EntryLoc(NDX).Loc(0)
         IY = .EntryLoc(NDX).Loc(1)
         MapData(IX, IY).Flags(NDX + 2) = True
      Next NDX
      For NDX = 0 To .NSpecial
         If .Special(NDX).Loc(0) <> 100 Then
            IX = .Special(NDX).Loc(0)
            IY = .Special(NDX).Loc(1)
            MapData(IX, IY).Special = NDX
         End If
      Next NDX
      For NDX = 0 To cstTwnSign
         If .Sign(NDX).Loc(0) <> 100 Then
            IX = .Sign(NDX).Loc(0)
            IY = .Sign(NDX).Loc(1)
            MapData(IX, IY).Sign = NDX
         End If
      Next NDX
      For NDX = 0 To 15
         InitMapArea .AreaLoc(NDX), 0
      Next NDX
      InitMapBoundary .Boundary
      For NDX = 0 To 3
         If SaveItemArea(NDX).TownNum = CurTown Then
            InitMapSave SaveItemArea(NDX).Loc
         End If
      Next NDX
      For NDX = 0 To .NField
         If .Field(NDX).Loc(0) <> 100 Then
            IDX = .Field(NDX).Num
            IX = .Field(NDX).Loc(0)
            IY = .Field(NDX).Loc(1)
            MapData(IX, IY).Field(IDX) = NDX
         End If
      Next NDX
      For NDX = 0 To .NItem
         If .Item(NDX).Loc(0) <> 100 Then
            IX = .Item(NDX).Loc(0)
            IY = .Item(NDX).Loc(1)
            IDX = MapData(IX, IY).NItems
            IDX = IDX + 1
            MapData(IX, IY).NItems = IDX
            ReDim Preserve MapData(IX, IY).Item(IDX)
            MapData(IX, IY).Item(IDX) = NDX
         End If
      Next NDX
      InitMapMonst
      End With
      For NDX = 0 To 23
         If Boat(NDX).Town = CurTown Then
            IX = Boat(NDX).Loc(0)
            IY = Boat(NDX).Loc(1)
            MapData(IX, IY).Transport = 0
         End If
      Next NDX
      For NDX = 0 To 23
         If Horse(NDX).Town = CurTown Then
            IX = Horse(NDX).Loc(0)
            IY = Horse(NDX).Loc(1)
            MapData(IX, IY).Transport = 1
         End If
      Next NDX
   Case 3
      MapData(0, 0).Terrain = 90
      MapData(0, 49).Terrain = 90
      MapData(49, 0).Terrain = 90
      MapData(49, 49).Terrain = 90
      For IX = 1 To 48
         If CurOutX = 0 Then
            MapData(0, IX).Terrain = 90
         Else
            MapData(0, IX).Terrain = OutData(CurOutX - 1, CurOutY).Map(47, IX - 1)
         End If
         If CurOutX = Scen.OutSize(0) - 1 Then
            MapData(49, IX).Terrain = 90
         Else
            MapData(49, IX).Terrain = OutData(CurOutX + 1, CurOutY).Map(0, IX - 1)
         End If
         If CurOutY = 0 Then
            MapData(IX, 0).Terrain = 90
         Else
            MapData(IX, 0).Terrain = OutData(CurOutX, CurOutY - 1).Map(IX - 1, 47)
         End If
         If CurOutY = Scen.OutSize(1) - 1 Then
            MapData(IX, 49).Terrain = 90
         Else
            MapData(IX, 49).Terrain = OutData(CurOutX, CurOutY + 1).Map(IX - 1, 0)
         End If
      Next IX
      For IX = 1 To 48
         For IY = 1 To 48
            MapData(IX, IY).Terrain = OutData(CurOutX, CurOutY).Map(IX - 1, IY - 1)
         Next IY
      Next IX
      For IX = 0 To MapSize
         For IY = 0 To MapSize
            MapData(IX, IY).Special = -1
            MapData(IX, IY).Sign = -1
            MapData(IX, IY).Town = -1
         Next IY
      Next IX
      If CurOutX = Scen.StartOutdoors(0) And CurOutY = Scen.StartOutdoors(1) Then
         IX = Scen.StartOutCoord(0) + 1
         IY = Scen.StartOutCoord(1) + 1
         MapData(IX, IY).Flags(0) = True
      End If
      With OutData(CurOutX, CurOutY)
      For NDX = 0 To 3
         If .WanderingLoc(NDX).Loc(0) <> 100 Then
            IX = .WanderingLoc(NDX).Loc(0) + 1
            IY = .WanderingLoc(NDX).Loc(1) + 1
            MapData(IX, IY).Flags(1) = True
         End If
      Next NDX
      For NDX = 0 To .NSpecial
         If .Special(NDX).Loc(0) <> 100 Then
            IX = .Special(NDX).Loc(0) + 1
            IY = .Special(NDX).Loc(1) + 1
            MapData(IX, IY).Special = NDX
         End If
      Next NDX
      For NDX = 0 To cstOutSign
         If .Sign(NDX).Loc(0) <> 100 Then
            IX = .Sign(NDX).Loc(0) + 1
            IY = .Sign(NDX).Loc(1) + 1
            MapData(IX, IY).Sign = NDX
         End If
      Next NDX
      For NDX = 0 To cstOutTown
         If .Town(NDX).Loc(0) <> 100 Then
            IX = .Town(NDX).Loc(0) + 1
            IY = .Town(NDX).Loc(1) + 1
            MapData(IX, IY).Town = NDX
         End If
      Next NDX
      For NDX = 0 To 7
         InitMapArea .AreaLoc(NDX), 1
      Next NDX
      End With
   End Select
End Sub

Public Sub InitMapArea(AreaRec As typAreaLoc, ByVal Adj As Integer)
   Dim IX As Integer
   Dim Used As Integer
   
   Used = 0
   For IX = 0 To 3
      Used = Used + AreaRec.Loc(IX)
   Next IX
   If Used = 0 Then Exit Sub
   For IX = AreaRec.Loc(cLeft) To AreaRec.Loc(cRight)
      MapData(IX + Adj, AreaRec.Loc(cTop) + Adj).Area(0) = True
      MapData(IX + Adj, AreaRec.Loc(cTop) + Adj).Area(2) = True
      MapData(IX + Adj, AreaRec.Loc(cBottom) + Adj).Area(0) = True
      MapData(IX + Adj, AreaRec.Loc(cBottom) + Adj).Area(2) = True
   Next IX
   For IX = AreaRec.Loc(cTop) To AreaRec.Loc(cBottom)
      MapData(AreaRec.Loc(cLeft) + Adj, IX + Adj).Area(1) = True
      MapData(AreaRec.Loc(cLeft) + Adj, IX + Adj).Area(3) = True
      MapData(AreaRec.Loc(cRight) + Adj, IX + Adj).Area(1) = True
      MapData(AreaRec.Loc(cRight) + Adj, IX + Adj).Area(3) = True
   Next IX
   MapData(AreaRec.Loc(cLeft) + Adj, AreaRec.Loc(cTop) + Adj).Area(0) = False
   MapData(AreaRec.Loc(cLeft) + Adj, AreaRec.Loc(cTop) + Adj).Area(1) = False
   MapData(AreaRec.Loc(cLeft) + Adj, AreaRec.Loc(cBottom) + Adj).Area(0) = False
   MapData(AreaRec.Loc(cLeft) + Adj, AreaRec.Loc(cBottom) + Adj).Area(3) = False
   MapData(AreaRec.Loc(cRight) + Adj, AreaRec.Loc(cTop) + Adj).Area(1) = False
   MapData(AreaRec.Loc(cRight) + Adj, AreaRec.Loc(cTop) + Adj).Area(2) = False
   MapData(AreaRec.Loc(cRight) + Adj, AreaRec.Loc(cBottom) + Adj).Area(2) = False
   MapData(AreaRec.Loc(cRight) + Adj, AreaRec.Loc(cBottom) + Adj).Area(3) = False
End Sub

Public Sub InitMapBoundary(AreaRec As typAreaLoc)
   Dim IX As Integer
   Dim IY As Integer
   
   For IX = 0 To MapSize
      For IY = 0 To MapSize
         MapData(IX, IY).Area(4) = False
         MapData(IX, IY).Area(5) = False
         MapData(IX, IY).Area(6) = False
         MapData(IX, IY).Area(7) = False
      Next IY
   Next IX
   For IX = AreaRec.Loc(0) To AreaRec.Loc(2)
      MapData(IX, AreaRec.Loc(1)).Area(4) = True
      MapData(IX, AreaRec.Loc(1)).Area(6) = True
      MapData(IX, AreaRec.Loc(3)).Area(4) = True
      MapData(IX, AreaRec.Loc(3)).Area(6) = True
   Next IX
   For IX = AreaRec.Loc(1) To AreaRec.Loc(3)
      MapData(AreaRec.Loc(0), IX).Area(5) = True
      MapData(AreaRec.Loc(0), IX).Area(7) = True
      MapData(AreaRec.Loc(2), IX).Area(5) = True
      MapData(AreaRec.Loc(2), IX).Area(7) = True
   Next IX
   MapData(AreaRec.Loc(0), AreaRec.Loc(1)).Area(4) = False
   MapData(AreaRec.Loc(0), AreaRec.Loc(1)).Area(5) = False
   MapData(AreaRec.Loc(0), AreaRec.Loc(3)).Area(4) = False
   MapData(AreaRec.Loc(0), AreaRec.Loc(3)).Area(7) = False
   MapData(AreaRec.Loc(2), AreaRec.Loc(1)).Area(5) = False
   MapData(AreaRec.Loc(2), AreaRec.Loc(1)).Area(6) = False
   MapData(AreaRec.Loc(2), AreaRec.Loc(3)).Area(6) = False
   MapData(AreaRec.Loc(2), AreaRec.Loc(3)).Area(7) = False
End Sub

Public Sub InitMapSave(ByVal AreaRec As Variant)
   Dim IX As Integer
   Dim Used As Integer
   
   Used = 0
   For IX = 0 To 3
      Used = Used + AreaRec(IX)
   Next IX
   If Used = 0 Then Exit Sub
   For IX = AreaRec(0) To AreaRec(2)
      MapData(IX, AreaRec(1)).Area(8) = True
      MapData(IX, AreaRec(1)).Area(10) = True
      MapData(IX, AreaRec(3)).Area(8) = True
      MapData(IX, AreaRec(3)).Area(10) = True
   Next IX
   For IX = AreaRec(1) To AreaRec(3)
      MapData(AreaRec(0), IX).Area(9) = True
      MapData(AreaRec(0), IX).Area(11) = True
      MapData(AreaRec(2), IX).Area(9) = True
      MapData(AreaRec(2), IX).Area(11) = True
   Next IX
   MapData(AreaRec(0), AreaRec(1)).Area(8) = False
   MapData(AreaRec(0), AreaRec(1)).Area(9) = False
   MapData(AreaRec(0), AreaRec(3)).Area(8) = False
   MapData(AreaRec(0), AreaRec(3)).Area(11) = False
   MapData(AreaRec(2), AreaRec(1)).Area(9) = False
   MapData(AreaRec(2), AreaRec(1)).Area(10) = False
   MapData(AreaRec(2), AreaRec(3)).Area(10) = False
   MapData(AreaRec(2), AreaRec(3)).Area(11) = False
End Sub

Public Sub InitMapMonst()
   Dim IX As Integer
   Dim IY As Integer
   Dim IDX As Integer
   Dim MapX As Integer
   Dim MapY As Integer
   Dim MonstNum As Integer
   Dim PicNum As Integer
   Dim PicTyp As Integer
   
   For IX = 0 To MapSize
      For IY = 0 To MapSize
         MapData(IX, IY).NMonst = -1
         ReDim MapData(IX, IY).Monst(1, 0)
      Next IY
   Next IX
   With TownData(CurTown)
   For MonstNum = 0 To .NMonst
      If .Monster(MonstNum).Loc(0) <> 100 Then
         MapX = .Monster(MonstNum).Loc(0)
         MapY = .Monster(MonstNum).Loc(1)
         PicNum = MonsterDef(.Monster(MonstNum).Num).Pict
         If PicNum < 1000 Then
            PicTyp = MonstPicData(PicNum).PicType
         ElseIf PicNum < 2000 Then
            PicTyp = 1
         ElseIf PicNum < 3000 Then
            PicTyp = 2
         ElseIf PicNum < 4000 Then
            PicTyp = 3
         Else
            PicTyp = 4
         End If
         IDX = MapData(MapX, MapY).NMonst
         IDX = IDX + 1
         MapData(MapX, MapY).NMonst = IDX
         ReDim Preserve MapData(MapX, MapY).Monst(1, IDX)
         MapData(MapX, MapY).Monst(0, IDX) = MonstNum
         MapData(MapX, MapY).Monst(1, IDX) = 0
         Select Case PicTyp
         Case 1
         Case 2
            IDX = MapData(MapX + 1, MapY).NMonst
            IDX = IDX + 1
            MapData(MapX + 1, MapY).NMonst = IDX
            ReDim Preserve MapData(MapX + 1, MapY).Monst(1, IDX)
            MapData(MapX + 1, MapY).Monst(0, IDX) = MonstNum
            MapData(MapX + 1, MapY).Monst(1, IDX) = 1
         Case 3
            IDX = MapData(MapX, MapY + 1).NMonst
            IDX = IDX + 1
            MapData(MapX, MapY + 1).NMonst = IDX
            ReDim Preserve MapData(MapX, MapY + 1).Monst(1, IDX)
            MapData(MapX, MapY + 1).Monst(0, IDX) = MonstNum
            MapData(MapX, MapY + 1).Monst(1, IDX) = 1
         Case 4
            IDX = MapData(MapX + 1, MapY).NMonst
            IDX = IDX + 1
            MapData(MapX + 1, MapY).NMonst = IDX
            ReDim Preserve MapData(MapX + 1, MapY).Monst(1, IDX)
            MapData(MapX + 1, MapY).Monst(0, IDX) = MonstNum
            MapData(MapX + 1, MapY).Monst(1, IDX) = 1
            IDX = MapData(MapX, MapY + 1).NMonst
            IDX = IDX + 1
            MapData(MapX, MapY + 1).NMonst = IDX
            ReDim Preserve MapData(MapX, MapY + 1).Monst(1, IDX)
            MapData(MapX, MapY + 1).Monst(0, IDX) = MonstNum
            MapData(MapX, MapY + 1).Monst(1, IDX) = 2
            IDX = MapData(MapX + 1, MapY + 1).NMonst
            IDX = IDX + 1
            MapData(MapX + 1, MapY + 1).NMonst = IDX
            ReDim Preserve MapData(MapX + 1, MapY + 1).Monst(1, IDX)
            MapData(MapX + 1, MapY + 1).Monst(0, IDX) = MonstNum
            MapData(MapX + 1, MapY + 1).Monst(1, IDX) = 3
         End Select
      End If
   Next MonstNum
   End With
End Sub

Public Sub UpdateMapTerrain(obj As PictureBox, ByVal Terrain As Byte, _
      ByVal MapX As Integer, ByVal MapY As Integer, _
      ByVal ATX As Integer, ByVal ATY As Integer)
   Dim IX As Integer
   Dim IY As Integer
   Dim JX As Integer
   Dim JY As Integer
   Dim TerrX As Byte
   Dim SetMap(4, 4) As Integer
   
   If MapX < MapLimit(0) Or MapX > MapLimit(1) Then Exit Sub
   If MapY < MapLimit(0) Or MapY > MapLimit(1) Then Exit Sub
   TerrX = MapData(MapX, MapY).Terrain
   UpdMapTerr Terrain, MapX, MapY, obj, ATX, ATY
   Select Case Terrain
   Case 85, 88    ' rubble (left)
      UpdMapTerr Terrain + 1, MapX + 1, MapY, obj, ATX + MapCell.W, ATY
      Exit Sub
   Case 86, 89    ' rubble (right)
      UpdMapTerr Terrain - 1, MapX - 1, MapY, obj, ATX - MapCell.W, ATY
      Exit Sub
   End Select
   Select Case TerrX
   Case 85, 88
      UpdMapTerr MapDefTerrain, MapX + 1, MapY, obj, ATX + MapCell.W, ATY
      Exit Sub
   Case 86, 89
      UpdMapTerr MapDefTerrain, MapX - 1, MapY, obj, ATX - MapCell.W, ATY
      Exit Sub
   End Select
   For IX = -1 To 1
      For IY = -1 To 1
         JX = ATX + (IX * MapCell.W)
         JY = ATY + (IY * MapCell.H)
         ChkMapTerr MapX + IX, MapY + IY, obj, JX, JY
      Next IY
   Next IX
End Sub

Private Sub ChkMapTerr(ByVal MapX As Integer, ByVal MapY As Integer, _
      obj As PictureBox, ATX As Integer, ATY As Integer)
' Check adjacent terrain for complex terrain sets such as Cave Walls,
' Mountains, Hills, and Suface Water.
' Depending on adjacent terrain, changes may be made to terrain of the same set.

   Dim IX As Integer
   Dim IY As Integer
   Dim JX As Integer
   Dim JY As Integer
   Dim Terrain As Byte
   Dim TerrX As Byte
   Dim TerrPict As Integer
   Dim TerrSet As Integer
   Dim TerrSetX(-1 To 1, -1 To 1) As Boolean
   
   If MapX < MapLimit(0) Or MapX > MapLimit(1) Then Exit Sub
   If MapY < MapLimit(0) Or MapY > MapLimit(1) Then Exit Sub
   TerrX = MapData(MapX, MapY).Terrain
   TerrSet = TerrDef(TerrX).Set
   If TerrSet < 0 Then Exit Sub
   For IX = -1 To 1
      For IY = -1 To 1
         JX = MapX + IX
         JY = MapY + IY
         TerrSetX(IX, IY) = False
' check for edge of map conditions
         If JX < MapLimit(0) Or JX > MapLimit(1) Then
            TerrSetX(IX, IY) = True
         ElseIf JY < MapLimit(0) Or JY > MapLimit(1) Then
            TerrSetX(IX, IY) = True
' check if current cell picture is a member of a set
         ElseIf TerrDef(MapData(JX, JY).Terrain).Set = TerrSet Then
            TerrSetX(IX, IY) = True
' building walls match cave walls
         ElseIf TerrDef(MapData(JX, JY).Terrain).Pict >= 88 _
               And TerrDef(MapData(JX, JY).Terrain).Pict <= 120 _
               And TerrSet = 0 Then
            TerrSetX(IX, IY) = True
' waterfall matches anything
         ElseIf TerrDef(MapData(JX, JY).Terrain).Pict = 405 Then
            TerrSetX(IX, IY) = True
' check for special cases for hills/mtns such as caves
         ElseIf TerrDef(MapData(JX, JY).Terrain).Pict >= 192 _
               And TerrDef(MapData(JX, JY).Terrain).Pict <= 195 Then
            If TerrSet = 1 Or TerrSet = 2 Then
               TerrSetX(IX, IY) = True
            End If
         ElseIf TerrDef(MapData(JX, JY).Terrain).Pict >= 240 _
               And TerrDef(MapData(JX, JY).Terrain).Pict <= 243 Then
            If TerrSet = 0 Then
               TerrSetX(IX, IY) = True
            End If
' check for special cases for cave wall
         ElseIf TerrDef(MapData(JX, JY).Terrain).Pict >= 5 _
               And TerrDef(MapData(JX, JY).Terrain).Pict <= 17 _
               And TerrSet = 0 Then
                  TerrSetX(IX, IY) = True
' check for special cases in water
         ElseIf TerrDef(MapData(JX, JY).Terrain).Pict >= 59 _
               And TerrDef(MapData(JX, JY).Terrain).Pict <= 66 _
               And TerrSet = 3 Then
                  TerrSetX(IX, IY) = True
' hills and mountains match each other in certain ways
         ElseIf TerrSet = 2 Then
            If (TerrDef(MapData(JX, JY).Terrain).Set = 1 Or _
             TerrDef(MapData(JX, JY).Terrain).Set = 2) Then
               TerrSetX(IX, IY) = True
            End If
         End If
      Next IY
   Next IX
   Terrain = TerrainSet(TerrSet, 0)
   
   If TerrSetX(-1, -1) And TerrSetX(0, -1) And TerrSetX(1, -1) And _
         TerrSetX(-1, 0) And TerrSetX(1, 0) And TerrSetX(-1, 1) And _
         TerrSetX(0, 1) Then
      If TerrSetX(1, 1) Then
         If TerrX = 23 Or TerrX = 37 Then
'           Exceptions for High mountains and hills
            Terrain = TerrX
         Else
            Terrain = TerrainSet(TerrSet, 0)
         End If
      Else
         Terrain = TerrainSet(TerrSet, 12)
      End If
   ElseIf TerrSetX(-1, -1) And TerrSetX(0, -1) And Not TerrSetX(1, -1) And _
         TerrSetX(-1, 0) And TerrSetX(1, 0) And TerrSetX(-1, 1) And _
         TerrSetX(0, 1) Then
      Terrain = TerrainSet(TerrSet, 11)
   ElseIf TerrSetX(-1, -1) And TerrSetX(0, -1) And TerrSetX(-1, 0) And _
         TerrSetX(1, 0) And Not TerrSetX(-1, 1) And TerrSetX(0, 1) Then
      Terrain = TerrainSet(TerrSet, 9)
   ElseIf Not TerrSetX(-1, -1) And TerrSetX(0, -1) And TerrSetX(-1, 0) And _
         TerrSetX(1, 0) And TerrSetX(0, 1) Then
      Terrain = TerrainSet(TerrSet, 10)
   ElseIf TerrSetX(0, -1) And TerrSetX(-1, 0) Then
      If TerrSetX(1, 0) Then
         Terrain = TerrainSet(TerrSet, 1)
      ElseIf Not TerrSetX(1, 0) And TerrSetX(0, 1) Then
         Terrain = TerrainSet(TerrSet, 3)
      Else
         Terrain = TerrainSet(TerrSet, 2)
      End If
   ElseIf Not TerrSetX(0, -1) And TerrSetX(-1, 0) Then
      If TerrSetX(1, 0) Then
         Terrain = TerrainSet(TerrSet, 5)
      Else
         Terrain = TerrainSet(TerrSet, 4)
      End If
   ElseIf TerrSetX(0, -1) Then
      If TerrSetX(0, 1) Then
         Terrain = TerrainSet(TerrSet, 7)
      Else
         Terrain = TerrainSet(TerrSet, 8)
      End If
   Else
      Terrain = TerrainSet(TerrSet, 6)
   End If
   UpdMapTerr Terrain, MapX, MapY, obj, ATX, ATY
End Sub

Private Sub UpdMapTerr(ByVal Terrain As Byte, _
      ByVal MapX As Integer, ByVal MapY As Integer, _
      obj As PictureBox, ByVal ATX As Integer, ByVal ATY As Integer)
   
   If MapX < MapLimit(0) Or MapX > MapLimit(1) Then Exit Sub
   If MapY < MapLimit(0) Or MapY > MapLimit(1) Then Exit Sub
   MapData(MapX, MapY).Terrain = Terrain
   Select Case MapContext
   Case 0, 1, 2
      With TownData(CurTown)
      .Map(MapX, MapY) = Terrain
      End With
   Case 3
      With OutData(CurOutX, CurOutY)
      .Map(MapX - 1, MapY - 1) = Terrain
      End With
   End Select
   PaintMapCell obj, ATX, ATY, MapX, MapY
End Sub

Public Sub ScenTextDump()
   Dim IX As Integer
   Dim IY As Integer
   Dim IDX As Integer
   Dim NDX As Integer
   Dim ScenTextFile As String
   
   On Error GoTo ErrHandler
   ScenTextFile = Mid(Scen.PathName, 1, Len(Scen.PathName) - 3) & "txt"
   Open ScenTextFile For Output As #3
   Print #3, "Scenario text for " & Scen.Text(0)
   Print #3, vbCrLf & "Scenario Text:" & vbCrLf
   For NDX = 0 To cstScnText
      Print #3, "   Message " & NDX & ": " & Scen.Text(NDX)
   Next NDX
   Print #3, vbCrLf & "Outdoor Sections Text:"
   For IX = 0 To Scen.OutSize(0) - 1
      For IY = 0 To Scen.OutSize(1) - 1
         Print #3, vbCrLf & "  Section X = " & IX & ", Y = " & IY & vbCrLf
         For NDX = 0 To cstOutText
            With OutData(IX, IY)
            Print #3, "   Message " & NDX & ": " & .Text(NDX)
            End With
         Next NDX
      Next IY
   Next IX
   Print #3, vbCrLf & "Town Text:" & vbCrLf
   For IX = 0 To Scen.NumTowns - 1
      Print #3, vbCrLf & "  Town = " & IX & ": " & TownData(IX).Text(0) & vbCrLf
      Print #3, "  Town Messages:"
      For NDX = 0 To cstTwnText
         With TownData(IX)
         Print #3, "  Message " & NDX & ": " & .Text(NDX)
         End With
      Next NDX
      Print #3, vbCrLf & "  TownDialogue:"
      For IY = 0 To 9
         IDX = IX * 10 + IY
         With DialogData(IX).Person(IY)
         Print #3, "  Personality " & IDX & " name: " & .Name
         Print #3, "  Personality " & IDX & " confused: " & .HuhResponse
         Print #3, "  Personality " & IDX & " look    : " & .LookResponse
         Print #3, "  Personality " & IDX & " ask name: " & .NameResponse
         Print #3, "  Personality " & IDX & " ask job : " & .JobResponse
         End With
      Next IY
      For IY = 0 To cstTwnDlogNode
         With DialogData(IX).Node(IY)
         Print #3, "  Node " & IY & " person  : " & .Personality
         Print #3, "  Node " & IY & " keywords: " & .Word(0) & " "; .Word(1)
         Print #3, "  Node " & IY & " type    : " & .Type
         Print #3, "  Node " & IY & " text0   : " & DialogData(IX).Node(IY).Text(0)
         Print #3, "  Node " & IY & " text1   : " & DialogData(IX).Node(IY).Text(1)
         End With
      Next IY
   Next IX
   
   Close #3
   Exit Sub
ErrHandler:
   Close #3
   MsgBox "ScenTextDump" & "Error encountered!" & vbCrLf & "Err# " & Err.Number & ", " & Err.Description _
      , vbCritical, "Error"
End Sub

